;
;****************************************************************************
;
;  Purpose:
;	Add Value In Acc To DPTR
;
;  Date:
;	05/11/85
;
;  Author:
;	John C. Wren
;
;  Modications:
;	02/04/97 - Added Description Fields For Archive
;
;  Processor:
;	Generic 8031
;
;  Assembler:
;	Avocet AVA51
;
;  Dependencies:
;	None
;
;  Files:
;	None
;
;  Philosophic:
;	None
;
;****************************************************************************
;
;  Includes
;
		seg	code
;
;****************************************************************************
;
;  Publics, Externs
;
		public	UTIL_ADCAD
;
;****************************************************************************
;
;  Description:
;	Add Value In Acc To DPTR
;
;  Entry Requirements:
;	Value In Acc To Add To DPTR
;
;  On Exit:
;	DPTR = DPTR + Acc
;
;  Affected:
;	PSW.CY, DPTR
;
;  Stack:
;	0 Bytes, Not Including Called Routines
;
;  Comments:
;	CY == 1 If DPTR + Acc > 0xffff
;
UTIL_ADCAD	proc
		push	acc			; Make Sure Acc Gets Saved
		add	a,dpl			; Add 'A' To DPL
		mov	dpl,a			; Move Result To DPL
		mov	a,dph			; Get DPH
		addc	a,#000h 		; If Carry Set, This Will Increment
		mov	dph,a			; Move Bck To DPH
		pop	acc			; Recover Original 'A'
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
		end
