;
;****************************************************************************
;
;  Purpose:
;	Calculate CRC-8 Values.  Uses The CCITT-8 Polynomial, Expressed As
;	X^8 + X^5 + X^4 + 1
;
;  Date:
;	08/03/93
;
;  Author:
;	John C. Wren
;
;  Modications:
;	02/04/97 - Added Description Fields For Archive
;
;  Processor:
;	Generic 8031
;
;  Assembler:
;	Avocet AVA51
;
;  Dependencies:
;	None
;
;  Files:
;	None
;
;  Philosophic:
;	None
; 
;****************************************************************************
;
;
;  Includes
;
;		%include "equates.inc"
		seg	code
;
;****************************************************************************
;
;  Publics
;
		public	CRC16_INIT
		public	CRC16_ADD
		public	CRC16_GET
;
		extrn	UTIL_ADCAD
;
;****************************************************************************
;
;  Description:
;	Initializes CRC Calculator.  Should Be Called To Reset The Running
;	Value.
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	None
;
;  Stack:
;	0 Bytes, Not Including Space Used By Called Routines
;
;  Comments:
;	None
;
CRC16_INIT	proc
		mov	D_CRC16_HI,#0		; Clear CRC16 High
		mov	D_CRC16_LO,#0		; Clear CRC16 Low
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
;  Description:
;	Adds Value In Acc To Running CRC Total
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	0 Bytes, Not Including Space Used By Called Routines
;
;  Comments:
;	None
;
CRC16_ADD	proc
		jmp	CRC16_ADD_CALC		; Use Calculation Method
		endproc
;
;****************************************************************************
;
;  Description:
;	Returns The Accumulated CRC Value
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	DPTR Has Accumulated CRC Value
;
;  Affected:
;	DPTR
;
;  Stack:
;	0 Bytes, Not Including Space Used By Called Routines
;
;  Comments:
;	None
;
CRC16_GET	proc
		mov	dph,D_CRC16_HI		; Get CRC16 High
		mov	dpl,D_CRC16_LO		; Get CRC16 Low
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
;  Description:
;	Calculates Value In Acc Into The Running CRC Total, Using The 
;	Calculation Method (Slower But Smaller).
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	2 Bytes, Not Including Space Used By Called Routines
;
;  Comments:
;	Must Use Register Bank 0.  The Routine Saves R0 By Pushing Location
;	0 (Since R0 Can't Be Pushed By Reference).  If Alternate Register
;	Banks Need To Be Used, R0 Could Be Moved To Acc And Pushed.
;
CRC16_ADD_CALC	proc
		push	0		; Save R0
		push	acc		; Save Acc
		mov	r0,#8		; 8 Bits In A Byte
		xrl	D_CRC16_HI,a	; HI ^= Data
l?p1		clr	c		; 0 Into Low Bit
		mov	a,D_CRC16_LO	; D_CRC << 1
		rlc	a		; Shift Left
		mov	D_CRC16_LO,a	; Store Back
		mov	a,D_CRC16_HI	; Get High Byte
		rlc	a		; Shift Left
		mov	D_CRC16_HI,a	; Store Back
		jnc	l?p2		; Skip If Bit 15 Wasn't Set
		xrl	D_CRC16_HI,#10h	; XOR In Polynomial High
		xrl	D_CRC16_LO,#21h	; XOR In Polynomial Low
l?p2		djnz	r0,l?p1		; Repeat R0 More Times
		pop	acc		; Recover Acc
		pop	0		; Recover R0
		ret			; Return To Caller
		endproc
;
;****************************************************************************
;
;  Description:
;	Calculates Value In Acc Into The Running CRC Total, Using The Table
;	Method.  (Faster But Larger)
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	5 Bytes, Not Including Space Used By Called Routines
;
;  Comments:
;	None
;
CRC16_ADD_TABLE	proc
		push	dph			; Save DPH
		push	dpl			; Save DPL
		push	acc			; Save Acc
;
		mov	dptr,#CRC16_DATA	; Point To Table
		xrl	a,D_CRC16_HI		; XOR High Of CRC With Character
		call	UTIL_ADCAD		; Add 'A' To 'DPTR'
		call	UTIL_ADCAD		; Add 'A' To 'DPTR' (Yes, Twice)
;
		clr	a			; Clear For MOVC
		movc	a,@a+dptr		; Get High Of Table Entry
		xrl	a,D_CRC16_LO		; XOR With Low
		mov	D_CRC16_HI,a		; Store To High
;
		mov	a,#1			; Get Low Byte
		movc	a,@a+dptr		; Get Low Of Table Entry
		mov	D_CRC16_LO,a		; Store To Low Of CRC
;
		pop	acc			; Recover Acc
		pop	dpl			; Recover DPL
		pop	dph			; Recover DPH
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
;  Data For Table Method
;
CRC16_DATA	dw	00000h, 01021h, 02042h, 03063h, 04084h, 050A5h, 060C6h, 070E7h
		dw	08108h, 09129h, 0A14Ah, 0B16Bh, 0C18Ch, 0D1ADh, 0E1CEh, 0F1EFh
		dw	01231h, 00210h, 03273h, 02252h, 052B5h, 04294h, 072F7h, 062D6h
		dw	09339h, 08318h, 0B37Bh, 0A35Ah, 0D3BDh, 0C39Ch, 0F3FFh, 0E3DEh
		dw	02462h, 03443h, 00420h, 01401h, 064E6h, 074C7h, 044A4h, 05485h
		dw	0A56Ah, 0B54Bh, 08528h, 09509h, 0E5EEh, 0F5CFh, 0C5ACh, 0D58Dh
		dw	03653h, 02672h, 01611h, 00630h, 076D7h, 066F6h, 05695h, 046B4h
		dw	0B75Bh, 0A77Ah, 09719h, 08738h, 0F7DFh, 0E7FEh, 0D79Dh, 0C7BCh
		dw	048C4h, 058E5h, 06886h, 078A7h, 00840h, 01861h, 02802h, 03823h
		dw	0C9CCh, 0D9EDh, 0E98Eh, 0F9AFh, 08948h, 09969h, 0A90Ah, 0B92Bh
		dw	05AF5h, 04AD4h, 07AB7h, 06A96h, 01A71h, 00A50h, 03A33h, 02A12h
		dw	0DBFDh, 0CBDCh, 0FBBFh, 0EB9Eh, 09B79h, 08B58h, 0BB3Bh, 0AB1Ah
		dw	06CA6h, 07C87h, 04CE4h, 05CC5h, 02C22h, 03C03h, 00C60h, 01C41h
		dw	0EDAEh, 0FD8Fh, 0CDECh, 0DDCDh, 0AD2Ah, 0BD0Bh, 08D68h, 09D49h
		dw	07E97h, 06EB6h, 05ED5h, 04EF4h, 03E13h, 02E32h, 01E51h, 00E70h
		dw	0FF9Fh, 0EFBEh, 0DFDDh, 0CFFCh, 0BF1Bh, 0AF3Ah, 09F59h, 08F78h
		dw	09188h, 081A9h, 0B1CAh, 0A1EBh, 0D10Ch, 0C12Dh, 0F14Eh, 0E16Fh
		dw	01080h, 000A1h, 030C2h, 020E3h, 05004h, 04025h, 07046h, 06067h
		dw	083B9h, 09398h, 0A3FBh, 0B3DAh, 0C33Dh, 0D31Ch, 0E37Fh, 0F35Eh
		dw	002B1h, 01290h, 022F3h, 032D2h, 04235h, 05214h, 06277h, 07256h
		dw	0B5EAh, 0A5CBh, 095A8h, 08589h, 0F56Eh, 0E54Fh, 0D52Ch, 0C50Dh
		dw	034E2h, 024C3h, 014A0h, 00481h, 07466h, 06447h, 05424h, 04405h
		dw	0A7DBh, 0B7FAh, 08799h, 097B8h, 0E75Fh, 0F77Eh, 0C71Dh, 0D73Ch
		dw	026D3h, 036F2h, 00691h, 016B0h, 06657h, 07676h, 04615h, 05634h
		dw	0D94Ch, 0C96Dh, 0F90Eh, 0E92Fh, 099C8h, 089E9h, 0B98Ah, 0A9ABh
		dw	05844h, 04865h, 07806h, 06827h, 018C0h, 008E1h, 03882h, 028A3h
		dw	0CB7Dh, 0DB5Ch, 0EB3Fh, 0FB1Eh, 08BF9h, 09BD8h, 0ABBBh, 0BB9Ah
		dw	04A75h, 05A54h, 06A37h, 07A16h, 00AF1h, 01AD0h, 02AB3h, 03A92h
		dw	0FD2Eh, 0ED0Fh, 0DD6Ch, 0CD4Dh, 0BDAAh, 0AD8Bh, 09DE8h, 08DC9h
		dw	07C26h, 06C07h, 05C64h, 04C45h, 03CA2h, 02C83h, 01CE0h, 00CC1h
		dw	0EF1Fh, 0FF3Eh, 0CF5Dh, 0DF7Ch, 0AF9Bh, 0BFBAh, 08FD9h, 09FF8h
		dw	06E17h, 07E36h, 04E55h, 05E74h, 02E93h, 03EB2h, 00ED1h, 01EF0h
;
;****************************************************************************
;
;  Data Area
;
		seg	data
D_CRC16_HI	ds	1
D_CRC16_LO	ds	1
;
;****************************************************************************
;
		end
